//***************************************************************************
//
//  Program   : SLDEMO3.CPP
//
//  Programmer: Steven R Clabaugh
//              SRC Enterprises
//
//  Purpose   : Bare-bones Windows MFC application used to demonstrate
//              Slider Control Class.
//              Does not use a VIEW class or a DOCUMENT class.
//
//***************************************************************************
#include <afxwin.h>
#include <srcentsl.h>
#include "resource.h"
#include "sldemo3.h"

//***************************************************************************
//***************************************************************************
// Implementation for the application class 'CTheApp'
//***************************************************************************
//***************************************************************************

//***************************************************************************
//
//  Application Class 'InitApplication' member function
//
//***************************************************************************
BOOL CTheApp::InitApplication()
{

   // The reason we register a window class is to provide the ability to set
   // the client area to the color of our choice.
   // The class name is returned in the application class m_ClassName
   // data member and passed to the CMainWnd class's contructor within the
   // InitInstance function.
   m_WndClassName = AfxRegisterWndClass(
                       NULL,                               // Class Style
                       LoadStandardCursor(IDC_ARROW),      // Cursor
                       CreateSolidBrush(RGB(192,192,192)), // Client Area Color
                       LoadIcon(AFX_IDI_STD_FRAME)         // Application Icon
                 );

   return TRUE;

} // End CTheApp::InitApplication

//***************************************************************************
//
//  Application Class 'InitInstance' member function
//
//  Creates and shows the main window
//
//***************************************************************************
BOOL CTheApp::InitInstance()
{

   //  Declare the Application's Main Window object
   //    and call its constructor
   m_pMainWnd = new CMainWnd(m_WndClassName);

   // Make the window visable; Update its client area; return successfull
   m_pMainWnd->ShowWindow(m_nCmdShow);   // Show the window
   m_pMainWnd->UpdateWindow();           // Sends WM_PAINT Msg
   return TRUE;

} // End CTheApp::InitInstance

//**** End Application Class Implementation *********************************
//***************************************************************************
//***************************************************************************

//***************************************************************************
//***************************************************************************
// Implementation for the application's Main Window class 'CMainWnd'
//***************************************************************************
//***************************************************************************

//***************************************************************************
//
//  CMainWnd Class Constructor
//
//***************************************************************************
CMainWnd::CMainWnd(CString WndClassName)
{

   // Create the Main Window
   Create(WndClassName,                  // Window Class Name
          AfxGetAppName(),               // Text for Window Title Bar
          WS_OVERLAPPEDWINDOW,           // Window Style
          CRect(10,10,270,190),          // Window Position and Size
          NULL,                          // Overlapped Windows have no Parent
          "MAINMENU",                    // Main Menu Resource Name
          0,                             // No Extened style attributes
          NULL                           // Pointer Not Needed
         );

} // End CMainWnd::CMainWnd Class Constructor

//***************************************************************************
//
//  Create the message map for the main window procedure
//
//***************************************************************************
BEGIN_MESSAGE_MAP(CMainWnd, CFrameWnd)
   //{{AFX_MSG_MAP(CMainWnd)
   ON_COMMAND(ID_APP_ABOUT,OnAbout)
   ON_COMMAND(IDSL_MYSLIDER,OnMySlider)
   ON_WM_CREATE()
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

//**** End Message Map ******************************************************

//***************************************************************************
//
//  Main Window WM_CREATE Message Handler
//
//***************************************************************************
int CMainWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{


   // One note to make here, is that the last 3 parms in the Create
   // function must be type cast to UINT when programming with MFC
   // style programming. 

   m_MySlider.Create(
      NULL,                              // Slider Style
      (LPSTR)IDB_SLFACE1,                // Slider Face
      (LPSTR)IDB_SLKNOB1,                // Slider Knob
      50,14,                             // Slider Position
      6,                                 // Knob Slide position
      6,                                 // Knob upper limit position
      99,                                // Knob lower limit position
      0,100,                             // range min & max
      0,                                 // set a value
      TRUE,                              // Use a hand mouse cursor
      TRUE,                              // Enable the mouse
      (UINT)m_hWnd,                      // Parent window handle
      (UINT)IDSL_MYSLIDER,               // Slider ID value
      (UINT)AfxGetInstanceHandle()       // Program instance
   );

   m_MyGauge.Create(
      NULL,                              // Slider Style
      (LPSTR)IDB_GAUGE3F,                // Slider Face
      (LPSTR)IDB_GAUGE3K,                // Slider Knob
      150,10,                            // Slider Position
      5,                                 // Knob Slide position
      5,                                 // Knob upper limit position
      109,                               // Knob lower limit position
      0,100,                             // range min & max
      0,                                 // set a value
      FALSE,                             // Use a hand mouse cursor
      FALSE,                             // Disable the mouse
      (UINT)m_hWnd,                      // Parent window handle
      (UINT)IDSL_MYGAUGE,                // Slider ID value
      (UINT)AfxGetInstanceHandle()       // Program instance
   );

   m_MyGauge.SetVal(m_MySlider.GetVal(),TRUE);
   return 0;

}  // END WM_CREATE

//***************************************************************************
//
//  Main Window WM_COMMAMD:ID_ABOUT Command Message Handler
//
//***************************************************************************
void CMainWnd::OnAbout()
{

   CDialog about(IDD_ABOUTBOX);
   about.DoModal();

} // End CMainWnd::OnAbout

//***************************************************************************
//
//  Main Window WM_COMMAMD:MYSLIDER Command Message Handler
//
//***************************************************************************
void CMainWnd::OnMySlider()
{

   // Set the Gauge to the value of the Slider
   m_MyGauge.SetVal(m_MySlider.GetVal(),TRUE);

} // End CMainWnd::OnMySlider

//**** End Application's Main Window Class Implementation *******************
//***************************************************************************
//***************************************************************************

//***************************************************************************
//***************************************************************************
// Begin Application Execution
//***************************************************************************
//***************************************************************************

//***************************************************************************
//
//  Global Data
//
//***************************************************************************

// By declaring a global application object, the whole application runs
CTheApp NEAR theApp;
